// Language System
const translations = {
  en: {
    // Navigation
    navHome: "Home",
    navAbout: "About",
    navProgram: "Program",
    navSpeakers: "Speakers",
    navSessions: "Sessions",
    navPapers: "Call for Papers",
    navStartup: "Startup Track",
    navCallStartups: "Call for Startups",
    navCallInvestors: "Call for Investors",
    navGetInvolved: "Get Involved",
    navRegister: "Register",
    navContact: "Contact",

    // Hero Section
    heroTitle: "AI Days Tunisia 2025",
    heroTagline: "Where Innovation Meets Intelligence",
    heroSubtitle: "Enhanced 3-Day Premium Experience",
    heroDate: "December 19-21, 2025",
    heroLocation: "Laico Hotel, Yasmine Hammamet, Tunisia",
    heroDescription:
      "North Africa's premier FREE AI tech festival, uniting global AI enthusiasts, researchers, and innovators",
    heroSessions: "80+ Expert Sessions",
    heroSpeakers: "International Speakers",
    heroStartup: "Startup Pitch Competition",
    heroNetworking: "Networking Opportunities",
    heroKeynoteLabel: "Featuring Keynote Speakers From:",
    heroBtnRegister: "Register Now - FREE",
    heroBtnSubmit: "Submit Paper",
    heroBtnStartup: "Join Startup Track",

    // Countdown
    countdownDays: "Days",
    countdownHours: "Hours",
    countdownMinutes: "Minutes",
    countdownSeconds: "Seconds",
    countdownEventLive: "Event is Live!",

    // About Section
    aboutTitle: "Event Goals",
    aboutGoal1Title: "Democratize AI",
    aboutGoal1Desc:
      "Democratize AI across Tunisia and North Africa through education, research, and innovation",
    aboutGoal2Title: "Bridge Communities",
    aboutGoal2Desc: "Bridge academia and industry via impactful AI projects",
    aboutGoal3Title: "Connect Startups",
    aboutGoal3Desc:
      "Connect startups with international experts and investors through enhanced Startup Track",
    aboutGoal4Title: "Support Research",
    aboutGoal4Desc:
      "Support joint research with U.S. and European academic partners",

    // Call for Startups Section
    callStartupsTitle: "Call for Startups",
    callStartupsSubtitle:
      "Join AI Days Tunisia 2025 and showcase your innovative AI startup to the world!",
    callStartupsWhy: "Why Apply?",
    callStartupsBenefit1Title: "Global Exposure",
    callStartupsBenefit1Desc:
      "Present your startup to 1000+ AI professionals, investors, and industry leaders from around the world.",
    callStartupsBenefit2Title: "Funding Opportunities",
    callStartupsBenefit2Desc:
      "Connect with international investors actively seeking AI startups for funding and partnerships.",
    callStartupsBenefit3Title: "Mentorship Access",
    callStartupsBenefit3Desc:
      "Get one-on-one guidance from successful entrepreneurs and AI industry experts.",
    callStartupsBenefit4Title: "Competition & Awards",
    callStartupsBenefit4Desc:
      "Compete for startup awards, cash prizes, and incubation opportunities.",
    callStartupsHow: "How to Apply",
    callStartupsStep1: "Submit Application",
    callStartupsStep1Desc:
      "Complete our online application form with your startup details and pitch deck.",
    callStartupsStep2: "Review Process",
    callStartupsStep2Desc:
      "Our expert panel will review applications based on innovation, impact, and scalability.",
    callStartupsStep3: "Selection & Pitch",
    callStartupsStep3Desc:
      "Selected startups will be invited to pitch at AI Days Tunisia 2025.",
    callStartupsDeadline: "Application Deadline",
    callStartupsDeadlineDate: "December 10, 2025",
    callStartupsRequirements: "Requirements",
    callStartupsReq1: "AI-focused startup or innovative project",
    callStartupsReq2: "Working prototype or MVP",
    callStartupsReq3: "Clear business model and market strategy",
    callStartupsReq4: "Team commitment to attend the full event",
    callStartupsReq5: "Pitch deck (max 10 slides)",
    callStartupsApplyBtn: "Apply Now",
    callStartupsQuestionsBtn: "Have Questions?",

    // Call for Investors Section
    callInvestorsTitle: "Call for Investors",
    callInvestorsSubtitle:
      "Discover the next generation of AI startups at North Africa's premier tech event!",
    callInvestorsWhy: "Why Participate?",
    callInvestorsBenefit1Title: "Premium Deal Flow",
    callInvestorsBenefit1Desc:
      "Access to pre-screened, high-potential AI startups from MENA and beyond.",
    callInvestorsBenefit2Title: "Regional Insights",
    callInvestorsBenefit2Desc:
      "Deep dive into the North African AI ecosystem and emerging market opportunities.",
    callInvestorsBenefit3Title: "Direct Access",
    callInvestorsBenefit3Desc:
      "Private meetings with startup founders and exclusive networking opportunities.",
    callInvestorsBenefit4Title: "Market Intelligence",
    callInvestorsBenefit4Desc:
      "Access to market research, trend analysis, and investment landscape reports.",
    callInvestorsPackages: "Investment Package",
    callInvestorsPackage2Title: "VIP Investor Package",
    callInvestorsPackage2Price: "Premium",
    callInvestorsPackage2Feature1: "Access to all startup pitches",
    callInvestorsPackage2Feature2: "Private investor lounge access",
    callInvestorsPackage2Feature3: "One-on-one startup meetings",
    callInvestorsPackage2Feature4: "Exclusive dinner with top entrepreneurs",
    callInvestorsPackage2Feature5: "Priority access to due diligence materials",
    callInvestorsPackage2Feature6: "Networking sessions",
    callInvestorsPackage2Feature7: "Conference materials",
    callInvestorsPackage2Feature8: "Post-event startup contact list",
    callInvestorsJoin: "Join Our Investor Network",
    callInvestorsJoinDesc:
      "Register as an investor to get early access to startup profiles and exclusive networking opportunities.",
    callInvestorsFormTitle: "Investor Registration",
    callInvestorsField1: "Investment Focus Areas",
    callInvestorsField2: "Investment Stage Preference",
    callInvestorsField3: "Geographic Focus",
    callInvestorsField4: "Investment Range",
    callInvestorsRegisterBtn: "Register as Investor",
    callInvestorsPartnerBtn: "Partnership Inquiry",

    // Sponsors Section
    sponsorsTitle: "🤝 Call for Sponsors – AI Days Tunisia 2025",
    sponsorsIntro:
      "Partnering with AI Days Tunisia 2025 is more than supporting an event. It's about:",
    sponsorsBenefit1: "🔹 Demonstrating your social commitment",
    sponsorsBenefit2: "🔹 Strengthening your local presence",
    sponsorsBenefit3: "🔹 Showcasing your CSR initiatives",
    sponsorsPackagesTitle: "💡 Sponsorship Packages",
    sponsorsMajorPartner: "🏆 Major Partner",
    sponsorsMajorFeature1: "Logo on all media",
    sponsorsMajorFeature2: "5 social media posts",
    sponsorsMajorFeature3: "Video spot during keynotes",
    sponsorsMajorFeature4: "VIP badge & private evening",
    sponsorsInstitutionalPartner: "🏅 Institutional Partner",
    sponsorsInstitutionalFeature1: "Logo on website + social media",
    sponsorsInstitutionalFeature2: "3 dedicated posts",
    sponsorsInstitutionalFeature3: "Mention in newsletters",
    sponsorsCitizenSupport: "🤝 Citizen Support",
    sponsorsCitizenFeature1: "Logo on website & partners file",
    sponsorsCitizenFeature2: "1 thank you post",
    sponsorsCitizenFeature3: "Public acknowledgment",
    sponsorsBecomeSponsor: "Become Sponsor",

    // Partnership Section
    partnersTitle: "🤝 Partnership Packages – AI Days Tunisia 2025",
    partnersIntro:
      "AI Days Tunisia 2025 offers partnership opportunities tailored to the expectations of banking institutions, combining visibility, CSR engagement and participation in the digital transformation of the country.",
    partnersSubIntro:
      "Each partnership is designed to give you strong exposure while highlighting your role as a social driver.",
    partnersPackagesTitle: "💡 Partnership Packages",
    partnersMajor: "🏆 Major Partner",
    partnersMajor1: "Logo on all media (posters, stage)",
    partnersMajor2: "5 dedicated social media posts",
    partnersMajor3: "Video spot during keynotes",
    partnersMajor4: "VIP badge & private evening",
    partnersMajor5: "Panel participation (upon validation)",
    partnersMajor6: "Access to KPI analytics",
    partnersMajor7: "B2B investor meeting",
    partnersMajor8: "Logo on website + networks + slides",
    partnersInstitutional: "🏅 Institutional Partner",
    partnersInstitutional1: "3 social media posts",
    partnersInstitutional2: "Mention in newsletters",
    partnersInstitutional3: "Pro badge + general access",
    partnersInstitutional4: "Press kit visibility",
    partnersInstitutional5: "Simplified KPI access",
    partnersCitizen: "🤝 Citizen Support",
    partnersCitizen1: "Logo on website & partners file",
    partnersCitizen2: "1 thank you post",
    partnersCitizen3: "Basic badge",
    partnersCitizen4: "Public acknowledgment during the event",
    partnersBecomePartner: "Become Partner",

    // Common
    selectLanguage: "Select Language",
  },
  fr: {
    // Navigation
    navHome: "Accueil",
    navAbout: "À propos",
    navProgram: "Programme",
    navSpeakers: "Conférenciers",
    navSessions: "Sessions",
    navPapers: "Appel à communications",
    navStartup: "Parcours Startup",
    navCallStartups: "Appel aux Startups",
    navCallInvestors: "Appel aux Investisseurs",
    navGetInvolved: "Participer",
    navRegister: "S'inscrire",
    navContact: "Contact",

    // Hero Section
    heroTitle: "AI Days Tunisie 2025",
    heroTagline: "Où l'Innovation Rencontre l'Intelligence",
    heroSubtitle: "Expérience Premium Améliorée de 3 Jours",
    heroDate: "19-21 Décembre 2025",
    heroLocation: "Hôtel Laico, Yasmine Hammamet, Tunisie",
    heroDescription:
      "Le festival technologique IA GRATUIT de premier plan en Afrique du Nord, unissant les passionnés, chercheurs et innovateurs IA du monde entier",
    heroSessions: "80+ Sessions d'Experts",
    heroSpeakers: "Conférenciers Internationaux",
    heroStartup: "Concours de Pitch Startup",
    heroNetworking: "Opportunités de Réseautage",
    heroKeynoteLabel: "Avec des Conférenciers Principaux de:",
    heroBtnRegister: "S'inscrire Maintenant - GRATUIT",
    heroBtnSubmit: "Soumettre un Article",
    heroBtnStartup: "Rejoindre le Parcours Startup",

    // Countdown
    countdownDays: "Jours",
    countdownHours: "Heures",
    countdownMinutes: "Minutes",
    countdownSeconds: "Secondes",
    countdownEventLive: "L'événement est en direct!",

    // About Section
    aboutTitle: "Objectifs de l'Événement",
    aboutGoal1Title: "Démocratiser l'IA",
    aboutGoal1Desc:
      "Démocratiser l'IA en Tunisie et en Afrique du Nord grâce à l'éducation, la recherche et l'innovation",
    aboutGoal2Title: "Relier les Communautés",
    aboutGoal2Desc:
      "Relier le monde académique et l'industrie via des projets IA impactants",
    aboutGoal3Title: "Connecter les Startups",
    aboutGoal3Desc:
      "Connecter les startups avec des experts internationaux et des investisseurs grâce au Parcours Startup amélioré",
    aboutGoal4Title: "Soutenir la Recherche",
    aboutGoal4Desc:
      "Soutenir la recherche conjointe avec des partenaires académiques américains et européens",

    // Call for Startups Section
    callStartupsTitle: "Appel aux Startups",
    callStartupsSubtitle:
      "Rejoignez AI Days Tunisia 2025 et présentez votre startup IA innovante au monde!",
    callStartupsWhy: "Pourquoi postuler?",
    callStartupsBenefit1Title: "Exposition Mondiale",
    callStartupsBenefit1Desc:
      "Présentez votre startup à plus de 1000 professionnels IA, investisseurs et leaders de l'industrie du monde entier.",
    callStartupsBenefit2Title: "Opportunités de Financement",
    callStartupsBenefit2Desc:
      "Connectez-vous avec des investisseurs internationaux recherchant activement des startups IA pour financement et partenariats.",
    callStartupsBenefit3Title: "Accès au Mentorat",
    callStartupsBenefit3Desc:
      "Obtenez des conseils individuels d'entrepreneurs à succès et d'experts de l'industrie IA.",
    callStartupsBenefit4Title: "Concours et Prix",
    callStartupsBenefit4Desc:
      "Participez aux concours de startups, prix en espèces et opportunités d'incubation.",
    callStartupsHow: "Comment postuler",
    callStartupsStep1: "Soumettre la Candidature",
    callStartupsStep1Desc:
      "Complétez notre formulaire de candidature en ligne avec les détails de votre startup et pitch deck.",
    callStartupsStep2: "Processus de Révision",
    callStartupsStep2Desc:
      "Notre panel d'experts évaluera les candidatures basées sur l'innovation, l'impact et la scalabilité.",
    callStartupsStep3: "Sélection et Pitch",
    callStartupsStep3Desc:
      "Les startups sélectionnées seront invitées à présenter lors d'AI Days Tunisia 2025.",
    callStartupsDeadline: "Date Limite de Candidature",
    callStartupsDeadlineDate: "10 Décembre 2025",
    callStartupsRequirements: "Exigences",
    callStartupsReq1: "Startup ou projet axé sur l'IA",
    callStartupsReq2: "Prototype fonctionnel ou MVP",
    callStartupsReq3: "Modèle d'affaires clair et stratégie de marché",
    callStartupsReq4: "Engagement de l'équipe à assister à tout l'événement",
    callStartupsReq5: "Pitch deck (max 10 diapositives)",
    callStartupsApplyBtn: "Postuler Maintenant",
    callStartupsQuestionsBtn: "Des Questions?",

    // Call for Investors Section
    callInvestorsTitle: "Appel aux Investisseurs",
    callInvestorsSubtitle:
      "Découvrez la prochaine génération de startups IA lors du premier événement tech d'Afrique du Nord!",
    callInvestorsWhy: "Pourquoi participer?",
    callInvestorsBenefit1Title: "Deal Flow Premium",
    callInvestorsBenefit1Desc:
      "Accès aux startups IA pré-sélectionnées à fort potentiel de MENA et au-delà.",
    callInvestorsBenefit2Title: "Perspectives Régionales",
    callInvestorsBenefit2Desc:
      "Plongée profonde dans l'écosystème IA nord-africain et opportunités de marchés émergents.",
    callInvestorsBenefit3Title: "Accès Direct",
    callInvestorsBenefit3Desc:
      "Réunions privées avec les fondateurs de startups et opportunités de réseautage exclusives.",
    callInvestorsBenefit4Title: "Intelligence de Marché",
    callInvestorsBenefit4Desc:
      "Accès aux études de marché, analyses de tendances et rapports du paysage d'investissement.",
    callInvestorsPackages: "Package d'Investissement",
    callInvestorsPackage2Title: "Package Investisseur VIP",
    callInvestorsPackage2Price: "Premium",
    callInvestorsPackage2Feature1: "Accès à tous les pitchs de startups",
    callInvestorsPackage2Feature2: "Accès au salon privé des investisseurs",
    callInvestorsPackage2Feature3: "Réunions individuelles avec les startups",
    callInvestorsPackage2Feature4: "Dîner exclusif avec les top entrepreneurs",
    callInvestorsPackage2Feature5:
      "Accès prioritaire aux matériaux de due diligence",
    callInvestorsPackage2Feature6: "Sessions de réseautage",
    callInvestorsPackage2Feature7: "Matériaux de conférence",
    callInvestorsPackage2Feature8:
      "Liste de contacts des startups post-événement",
    callInvestorsJoin: "Rejoignez Notre Réseau d'Investisseurs",
    callInvestorsJoinDesc:
      "Inscrivez-vous en tant qu'investisseur pour obtenir un accès anticipé aux profils de startups et opportunités de réseautage exclusives.",
    callInvestorsFormTitle: "Inscription Investisseur",
    callInvestorsField1: "Domaines d'Investissement Ciblés",
    callInvestorsField2: "Préférence de Phase d'Investissement",
    callInvestorsField3: "Focus Géographique",
    callInvestorsField4: "Gamme d'Investissement",
    callInvestorsRegisterBtn: "S'inscrire comme Investisseur",
    callInvestorsPartnerBtn: "Demande de Partenariat",

    // Sponsors Section
    sponsorsTitle: "🤝 Appel aux Sponsors – AI Days Tunisia 2025",
    sponsorsIntro:
      "S'associer aux AI Days Tunisia 2025, c'est bien plus que soutenir un événement. C'est :",
    sponsorsBenefit1: "🔹 Affirmer votre engagement sociétal",
    sponsorsBenefit2: "🔹 Renforcer votre ancrage local",
    sponsorsBenefit3: "🔹 Valoriser vos actions RSE",
    sponsorsPackagesTitle: "💡 Nos Formules",
    sponsorsMajorPartner: "🏆 Partenaire Majeur",
    sponsorsMajorFeature1: "Logo sur tous les supports",
    sponsorsMajorFeature2: "5 publications réseaux",
    sponsorsMajorFeature3: "Spot vidéo projeté",
    sponsorsMajorFeature4: "Badge VIP & soirée privée",
    sponsorsInstitutionalPartner: "🏅 Partenaire Institutionnel",
    sponsorsInstitutionalFeature1: "Logo site + réseaux + slides",
    sponsorsInstitutionalFeature2: "3 publications réseaux",
    sponsorsInstitutionalFeature3: "Mention newsletters",
    sponsorsCitizenSupport: "🤝 Soutien Citoyen",
    sponsorsCitizenFeature1: "Logo site & dossier partenaires",
    sponsorsCitizenFeature2: "1 post de remerciement",
    sponsorsCitizenFeature3: "Badge simple",
    sponsorsBecomeSponsor: "Devenir Sponsor",

    // Partnership Section
    partnersTitle: "🤝 Formules de Partenariat – AI Days Tunisia 2025",
    partnersIntro:
      "Les AI Days Tunisia 2025 proposent des formules de partenariat adaptées aux attentes des institutions bancaires, combinant visibilité, engagement RSE et participation à la transformation numérique du pays.",
    partnersSubIntro:
      "Chaque partenariat est pensé pour vous offrir une exposition de qualité tout en valorisant votre rôle de moteur social.",
    partnersPackagesTitle: "💡 Formules de Partenariat",
    partnersMajor: "🏆 Partenaire Majeur",
    partnersMajor1: "Logo sur tous les supports (affichage, scène)",
    partnersMajor2: "5 publications dédiées sur nos réseaux",
    partnersMajor3: "Spot vidéo projeté lors des keynotes",
    partnersMajor4: "Badge VIP & accès soirée privée",
    partnersMajor5: "Intervention panel (sous validation)",
    partnersMajor6: "Accès aux KPI (analytiques)",
    partnersMajor7: "Rencontre B2B investisseurs",
    partnersMajor8: "Logo site + réseaux + slides",
    partnersInstitutional: "🏅 Partenaire Institutionnel",
    partnersInstitutional1: "3 publications sur réseaux",
    partnersInstitutional2: "Mention dans les newsletters",
    partnersInstitutional3: "Badge pro + accès général",
    partnersInstitutional4: "Visibilité dossier presse",
    partnersInstitutional5: "Accès KPI simplifiés",
    partnersCitizen: "🤝 Soutien Citoyen",
    partnersCitizen1: "Logo sur site web & dossier partenaires",
    partnersCitizen2: "1 post de remerciement",
    partnersCitizen3: "Badge simple",
    partnersCitizen4: "Mention au public pendant l'événement",
    partnersBecomePartner: "Devenir Partenaire",

    // Common
    selectLanguage: "Choisir la langue",
  },
  ar: {
    // Navigation
    navHome: "الرئيسية",
    navAbout: "حول",
    navProgram: "البرنامج",
    navSpeakers: "المتحدثون",
    navSessions: "الجلسات",
    navPapers: "دعوة للأوراق",
    navStartup: "مسار الشركات الناشئة",
    navCallStartups: "دعوة للشركات الناشئة",
    navCallInvestors: "دعوة للمستثمرين",
    navGetInvolved: "شارك معنا",
    navRegister: "التسجيل",
    navContact: "اتصل بنا",

    // Hero Section
    heroTitle: "أيام الذكاء الاصطناعي تونس 2025",
    heroTagline: "حيث يلتقي الابتكار بالذكاء",
    heroSubtitle: "تجربة محسّنة مميزة لمدة ثلاثة أيام",
    heroDate: "19-21 ديسمبر 2025",
    heroLocation: "فندق لايكو، ياسمين الحمامات، تونس",
    heroDescription:
      "مهرجان التكنولوجيا الرائد المجاني للذكاء الاصطناعي في شمال أفريقيا، يجمع عشاق وباحثين ومبتكري الذكاء الاصطناعي من جميع أنحاء العالم",
    heroSessions: "80+ جلسة خبراء",
    heroSpeakers: "متحدثون دوليون",
    heroStartup: "مسابقة عرض الشركات الناشئة",
    heroNetworking: "فرص التواصل",
    heroKeynoteLabel: "يضم متحدثين رئيسيين من:",
    heroBtnRegister: "سجل الآن - مجاناً",
    heroBtnSubmit: "أرسل ورقة بحثية",
    heroBtnStartup: "انضم لمسار الشركات الناشئة",

    // Countdown
    countdownDays: "أيام",
    countdownHours: "ساعات",
    countdownMinutes: "دقائق",
    countdownSeconds: "ثواني",
    countdownEventLive: "الحدث مباشر الآن!",

    // About Section
    aboutTitle: "أهداف الحدث",
    aboutGoal1Title: "إضفاء الطابع الديمقراطي على الذكاء الاصطناعي",
    aboutGoal1Desc:
      "إضفاء الطابع الديمقراطي على الذكاء الاصطناعي في تونس وشمال أفريقيا من خلال التعليم والبحث والابتكار",
    aboutGoal2Title: "ربط المجتمعات",
    aboutGoal2Desc:
      "ربط الأوساط الأكاديمية والصناعة من خلال مشاريع الذكاء الاصطناعي المؤثرة",
    aboutGoal3Title: "ربط الشركات الناشئة",
    aboutGoal3Desc:
      "ربط الشركات الناشئة بالخبراء الدوليين والمستثمرين من خلال مسار الشركات الناشئة المحسن",
    aboutGoal4Title: "دعم البحث",
    aboutGoal4Desc:
      "دعم البحث المشترك مع الشركاء الأكاديميين الأمريكيين والأوروبيين",

    // Call for Startups Section
    callStartupsTitle: "دعوة للشركات الناشئة",
    callStartupsSubtitle:
      "انضم إلى أيام الذكاء الاصطناعي تونس 2025 واعرض شركتك الناشئة المبتكرة في الذكاء الاصطناعي على العالم!",
    callStartupsWhy: "لماذا التقديم؟",
    callStartupsBenefit1Title: "التعرض العالمي",
    callStartupsBenefit1Desc:
      "اعرض شركتك الناشئة على أكثر من 1000 من محترفي الذكاء الاصطناعي والمستثمرين وقادة الصناعة من جميع أنحاء العالم.",
    callStartupsBenefit2Title: "فرص التمويل",
    callStartupsBenefit2Desc:
      "تواصل مع المستثمرين الدوليين الذين يبحثون بنشاط عن شركات ناشئة في الذكاء الاصطناعي للتمويل والشراكات.",
    callStartupsBenefit3Title: "الوصول للإرشاد",
    callStartupsBenefit3Desc:
      "احصل على إرشاد فردي من رواد الأعمال الناجحين وخبراء صناعة الذكاء الاصطناعي.",
    callStartupsBenefit4Title: "المسابقات والجوائز",
    callStartupsBenefit4Desc:
      "تنافس على جوائز الشركات الناشئة والجوائز النقدية وفرص الحضانة.",
    callStartupsHow: "كيفية التقديم",
    callStartupsStep1: "تقديم الطلب",
    callStartupsStep1Desc:
      "أكمل نموذج الطلب عبر الإنترنت مع تفاصيل شركتك الناشئة وعرض التقديمي.",
    callStartupsStep2: "عملية المراجعة",
    callStartupsStep2Desc:
      "ستراجع لجنة الخبراء لدينا الطلبات بناءً على الابتكار والتأثير وقابلية التوسع.",
    callStartupsStep3: "الاختيار والعرض",
    callStartupsStep3Desc:
      "ستتم دعوة الشركات الناشئة المختارة للعرض في أيام الذكاء الاصطناعي تونس 2025.",
    callStartupsDeadline: "الموعد النهائي للتطبيق",
    callStartupsDeadlineDate: "10 ديسمبر 2025",
    callStartupsRequirements: "المتطلبات",
    callStartupsReq1: "شركة ناشئة أو مشروع يركز على الذكاء الاصطناعي",
    callStartupsReq2: "نموذج أولي أو منتج قابل للتطبيق",
    callStartupsReq3: "نموذج عمل واضح واستراتيجية سوق",
    callStartupsReq4: "التزام الفريق بحضور الحدث كاملاً",
    callStartupsReq5: "عرض تقديمي (بحد أقصى 10 شرائح)",
    callStartupsApplyBtn: "تقدم الآن",
    callStartupsQuestionsBtn: "لديك أسئلة؟",

    // Call for Investors Section
    callInvestorsTitle: "دعوة للمستثمرين",
    callInvestorsSubtitle:
      "اكتشف الجيل القادم من شركات الذكاء الاصطناعي الناشئة في أهم حدث تقني في شمال أفريقيا!",
    callInvestorsWhy: "لماذا المشاركة؟",
    callInvestorsBenefit1Title: "تدفق صفقات مميز",
    callInvestorsBenefit1Desc:
      "الوصول إلى شركات ناشئة في الذكاء الاصطناعي مفحوصة مسبقاً وعالية الإمكانات من منا وما وراءها.",
    callInvestorsBenefit2Title: "رؤى إقليمية",
    callInvestorsBenefit2Desc:
      "غوص عميق في نظام الذكاء الاصطناعي في شمال أفريقيا وفرص الأسواق الناشئة.",
    callInvestorsBenefit3Title: "الوصول المباشر",
    callInvestorsBenefit3Desc:
      "اجتماعات خاصة مع مؤسسي الشركات الناشئة وفرص التواصل الحصرية.",
    callInvestorsBenefit4Title: "ذكاء السوق",
    callInvestorsBenefit4Desc:
      "الوصول إلى أبحاث السوق وتحليل الاتجاهات وتقارير المشهد الاستثماري.",
    callInvestorsPackages: "حزمة الاستثمار",
    callInvestorsPackage2Title: "حزمة المستثمر المميز",
    callInvestorsPackage2Price: "مميز",
    callInvestorsPackage2Feature1: "الوصول إلى جميع عروض الشركات الناشئة",
    callInvestorsPackage2Feature2: "الوصول إلى صالة المستثمرين الخاصة",
    callInvestorsPackage2Feature3: "اجتماعات فردية مع الشركات الناشئة",
    callInvestorsPackage2Feature4: "عشاء حصري مع كبار رواد الأعمال",
    callInvestorsPackage2Feature5: "وصول أولوي لمواد العناية الواجبة",
    callInvestorsPackage2Feature6: "جلسات التواصل",
    callInvestorsPackage2Feature7: "مواد المؤتمر",
    callInvestorsPackage2Feature8: "قائمة جهات اتصال الشركات الناشئة بعد الحدث",
    callInvestorsJoin: "انضم إلى شبكة المستثمرين لدينا",
    callInvestorsJoinDesc:
      "سجل كمستثمر للحصول على وصول مبكر لملفات الشركات الناشئة وفرص التواصل الحصرية.",
    callInvestorsFormTitle: "تسجيل المستثمر",
    callInvestorsField1: "مجالات التركيز الاستثماري",
    callInvestorsField2: "تفضيل مرحلة الاستثمار",
    callInvestorsField3: "التركيز الجغرافي",
    callInvestorsField4: "نطاق الاستثمار",
    callInvestorsRegisterBtn: "التسجيل كمستثمر",
    callInvestorsPartnerBtn: "استفسار الشراكة",

    // Sponsors Section
    sponsorsTitle: "🤝 دعوة للرعاة – أيام الذكاء الاصطناعي تونس 2025",
    sponsorsIntro:
      "المشاركة في أيام الذكاء الاصطناعي تونس 2025 ليست مجرد رعاية حدث، بل هي:",
    sponsorsBenefit1: "🔹 تأكيد التزامكم الاجتماعي",
    sponsorsBenefit2: "🔹 تعزيز وجودكم المحلي",
    sponsorsBenefit3: "🔹 إبراز مبادراتكم في المسؤولية الاجتماعية",
    sponsorsPackagesTitle: "💡 باقات الرعاية",
    sponsorsMajorPartner: "🏆 شريك رئيسي",
    sponsorsMajorFeature1: "شعار في جميع الوسائط",
    sponsorsMajorFeature2: "5 منشورات على الشبكات",
    sponsorsMajorFeature3: "إعلان فيديو أثناء الجلسات",
    sponsorsMajorFeature4: "شارات VIP & سهرة خاصة",
    sponsorsInstitutionalPartner: "🏅 شريك مؤسسي",
    sponsorsInstitutionalFeature1: "شعار على الموقع + الشبكات",
    sponsorsInstitutionalFeature2: "3 منشورات مخصصة",
    sponsorsInstitutionalFeature3: "ذكر في النشرات الإخبارية",
    sponsorsCitizenSupport: "🤝 دعم مجتمعي",
    sponsorsCitizenFeature1: "شعار على الموقع وملف الشركاء",
    sponsorsCitizenFeature2: "منشور شكر",
    sponsorsCitizenFeature3: "شكر علني أثناء الحدث",
    sponsorsBecomeSponsor: "كن راعياً",

    // Partnership Section
    partnersTitle: "🤝 صيغ الشراكة – أيام الذكاء الاصطناعي تونس 2025",
    partnersIntro:
      "تقدم أيام الذكاء الاصطناعي تونس 2025 صيغ شراكة مخصصة لتلبية توقعات المؤسسات المصرفية، جامعة بين الرؤية والمشاركة في المسؤولية الاجتماعية والمشاركة في التحول الرقمي للبلاد.",
    partnersSubIntro:
      "كل شراكة مصممة لتمنحكم عرضاً قوياً مع إبراز دوركم كمحرك اجتماعي.",
    partnersPackagesTitle: "💡 صيغ الشراكة",
    partnersMajor: "🏆 الشريك الرئيسي",
    partnersMajor1: "شعار على جميع الوسائط (ملصقات، منصة)",
    partnersMajor2: "5 منشورات مخصصة على شبكاتنا الاجتماعية",
    partnersMajor3: "عرض فيديو أثناء الجلسات الرئيسية",
    partnersMajor4: "بطاقة VIP و دخول الأمسية الخاصة",
    partnersMajor5: "مشاركة في لجنة (تخضع للتأكيد)",
    partnersMajor6: "الوصول إلى مؤشرات الأداء (KPI)",
    partnersMajor7: "لقاء B2B مع المستثمرين",
    partnersMajor8: "شعار على الموقع + الشبكات + الشرائح",
    partnersInstitutional: "🏅 الشريك المؤسسي",
    partnersInstitutional1: "3 منشورات على الشبكات",
    partnersInstitutional2: "ذكر في النشرات البريدية",
    partnersInstitutional3: "بطاقة احترافية + دخول عام",
    partnersInstitutional4: "الظهور في الملف الصحفي",
    partnersInstitutional5: "الوصول المبسط إلى KPI",
    partnersCitizen: "🤝 دعم المواطن",
    partnersCitizen1: "شعار على الموقع وملف الشركاء",
    partnersCitizen2: "منشور شكر واحد",
    partnersCitizen3: "بطاقة دخول بسيطة",
    partnersCitizen4: "ذكر علني أثناء الحدث",
    partnersBecomePartner: "كن شريكاً",

    // Common
    selectLanguage: "اختر اللغة",
  },
};

// Language System Functions
let currentLanguage = localStorage.getItem("language") || "en";

function updateContent(lang) {
  const elements = document.querySelectorAll("[data-translate]");
  elements.forEach((element) => {
    const key = element.getAttribute("data-translate");
    if (translations[lang] && translations[lang][key]) {
      element.textContent = translations[lang][key];
    }
  });

  // Update HTML lang attribute
  document.documentElement.lang = lang;

  // Add RTL support for Arabic
  if (lang === "ar") {
    document.body.setAttribute("dir", "rtl");
    document.body.classList.add("rtl");
  } else {
    document.body.setAttribute("dir", "ltr");
    document.body.classList.remove("rtl");
  }

  // Save language preference
  localStorage.setItem("language", lang);
  currentLanguage = lang;
}

function initializeLanguage() {
  updateContent(currentLanguage);
  const languageSelect = document.getElementById("languageSelect");
  if (languageSelect) {
    languageSelect.value = currentLanguage;
  }
}

// Navigation functionality
document.addEventListener("DOMContentLoaded", function () {
  // Initialize language system
  initializeLanguage();

  // Initialize countdown
  initializeCountdown();

  // Set dark theme by default
  const body = document.body;
  body.classList.add("dark-theme");
  localStorage.setItem("theme", "dark");

  // Hamburger menu functionality
  const navToggle = document.querySelector(".nav-toggle");
  const navMenu = document.querySelector(".nav-menu");
  const navLinks = document.querySelectorAll(".nav-menu a");

  // Navbar scroll effect
  window.addEventListener("scroll", function () {
    if (window.scrollY > 100) {
      navbar.classList.add("scrolled");
    } else {
      navbar.classList.remove("scrolled");
    }
  });

  // Mobile menu toggle
  navToggle.addEventListener("click", function () {
    navMenu.classList.toggle("active");

    // Animate hamburger menu
    const spans = navToggle.querySelectorAll("span");
    if (navMenu.classList.contains("active")) {
      spans[0].style.transform = "rotate(-45deg) translate(-5px, 6px)";
      spans[1].style.opacity = "0";
      spans[2].style.transform = "rotate(45deg) translate(-5px, -6px)";
    } else {
      spans[0].style.transform = "none";
      spans[1].style.opacity = "1";
      spans[2].style.transform = "none";
    }
  });
  const cards = document.querySelectorAll(".goal-card");
  const itemCount = cards.length;
  let angle = 360 / itemCount;
  let currAngle = 0;

  function rotateCarousel() {
    cards.forEach((card, i) => {
      let theta = (i * angle + currAngle) * (Math.PI / 180);
      let x = 300 * Math.cos(theta);
      let z = 300 * Math.sin(theta);

      card.style.transform = `translateX(${x}px) translateZ(${z}px)`;
    });

    currAngle -= angle; // move to next
  }

  setInterval(rotateCarousel, 3000);
  rotateCarousel();

  // Close mobile menu when clicking on a link
  navLinks.forEach((link) => {
    link.addEventListener("click", function () {
      navMenu.classList.remove("active");
      const spans = navToggle.querySelectorAll("span");
      spans[0].style.transform = "none";
      spans[1].style.opacity = "1";
      spans[2].style.transform = "none";
    });
  });

  // Smooth scrolling for navigation links
  navLinks.forEach((link) => {
    link.addEventListener("click", function (e) {
      e.preventDefault();
      const targetId = this.getAttribute("href");
      const targetSection = document.querySelector(targetId);

      if (targetSection) {
        const offsetTop = targetSection.offsetTop - 80;
        window.scrollTo({
          top: offsetTop,
          behavior: "smooth",
        });
      }
    });
  });
});

// Modal functionality
function openModal(modalId) {
  const modal = document.getElementById(modalId);
  modal.style.display = "block";
  document.body.style.overflow = "hidden";
}

function closeModal(modal) {
  modal.style.display = "none";
  document.body.style.overflow = "auto";
}

// Close modal when clicking on close button or outside modal
document.addEventListener("click", function (event) {
  if (event.target.classList.contains("close")) {
    const modal = event.target.closest(".modal");
    closeModal(modal);
  }

  if (event.target.classList.contains("modal")) {
    closeModal(event.target);
  }
});

// Close modal with Escape key
document.addEventListener("keydown", function (event) {
  if (event.key === "Escape") {
    const openModal = document.querySelector('.modal[style*="block"]');
    if (openModal) {
      closeModal(openModal);
    }
  }
});

// Sponsor contact function
function contactSponsor(packageType) {
  // Open the sponsor modal
  openModal("sponsorModal");

  // Pre-select the package in the form
  const packageSelect = document.querySelector("#sponsorModal select");
  if (packageSelect) {
    const packageMap = {
      platinum: "platinum",
      "official-partner": "official-partner",
      "official-sponsor": "official-sponsor",
      gold: "gold",
      silver: "silver",
    };

    if (packageMap[packageType]) {
      packageSelect.value = packageMap[packageType];
    }
  }
}

// Form submissions
document.addEventListener("DOMContentLoaded", function () {
  // Sessions data
  const sessionsData = [
    {
      title:
        "Cross-Industry Document Intelligence: From Healthcare to Enterprise Applications",
      speaker: "Ameni Amri",
      category: "AI",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "This session explores how modern OCR/NLP pipelines can transform document processing across multiple sectors, with methodologies applicable to: Healthcare Use Cases (Patient record digitization, Insurance claim processing, Clinical trial data extraction), Financial Services (Invoice processing, KYC document verification, Contract analysis), Government & Education (Administrative form processing, Academic record management, Archive digitization).",
    },
    {
      title:
        "PixOCR in Healthcare: AI-Powered Patient Data Extraction & Registration",
      speaker: "Ameni Amri",
      category: "AI & Healthcare",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "This session dives into PixOCR, a SaaS solution revolutionizing patient registration by automating data extraction from IDs, insurance cards, and referral letters to populate EHRs. Technical Architecture: OCR Stack using Tesseract and Google Cloud Vision, NLP Pipeline with spaCy and BioClinicalBERT, Integration with Apache NiFi, FastAPI backend, and React frontend. Includes GDPR/HIPAA compliance and real-world case studies.",
    },
    {
      title: "AAAAA - Ask Anyone Anything About Anything",
      speaker: "André Melancia",
      category: "AI",
      type: "Panel",
      duration: "45 mins",
      language: "English",
      description:
        "Have a question? We may have the answer. Or not. You won't know until you ask. Disclaimer: Food not provided, but on request we may recommend recipes for amazing dishes.",
    },
    {
      title: "Agents, Code, and Chaos: GitHub Copilot Meets Azure AI Foundry",
      speaker: "Muhammad Samiullah",
      category: "AI for Accessibility",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "What happens when GitHub Copilot's AI-powered coding collides with Azure AI Foundry's agent-based architecture? This session walks through building an AI-powered support ticket routing system using GitHub Copilot and Azure AI Foundry. Live demo showing how to use GitHub Copilot to rapidly scaffold code for an AI agent, connect to external APIs, and deploy in Azure AI Foundry.",
    },
    {
      title: "AI Ethics",
      speaker: "Houda CHIHI Chihi",
      category: "AI Ethics",
      type: "Keynote",
      duration: "45 mins",
      language: "English",
      description:
        "The talk is about highlighting the different ethics related to the use of AI.",
    },
    {
      title:
        "AI in Finance: From POC to Profit — Bridging the Corporate × Startup Gap",
      speaker: "Mariem Kamoun",
      category: "AI in Finance",
      type: "Keynote",
      duration: "Panel",
      language: "French",
      description:
        "Drawing on experience with leading financial institutions (Allianz, AXA, SCOR, CNP) and successful ventures, this session reveals what truly works to scale AI in finance/insurance. Attendees will walk away with actionable frameworks, proven metrics, and practical checklists to move AI from POC to profit.",
    },
    {
      title: "AI, Please Do My Job (…But Better)",
      speaker: "Oumayma Saddouri",
      category: "Generative AI",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "Discover how Generative AI can handle your repetitive tasks, boost your creativity, and help you work smarter not harder. Learn practical prompting techniques, see real-world examples, and watch how AI can turn rough ideas into polished results in seconds.",
    },
    {
      title: "Azure AI Workshop [V6]",
      speaker: "André Melancia",
      category: "AI",
      type: "Full Day Workshop",
      duration: "Full Day",
      language: "English",
      description:
        "This workshop introduces attendees to AI and Machine Learning services in the Microsoft ecosystem. Covers Azure AI Foundry, Azure AI Services, Machine Learning technologies, and practical hands-on experience. Prerequisites: Laptop, Azure subscription, and preferred development IDE.",
    },
    {
      title:
        "Beyond Automation: Measuring AI Proficiency to Unlock True Business Value",
      speaker: "Melissa Jurkoic",
      category: "AI",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "AI adoption is accelerating, but implementation alone doesn't guarantee success. This session introduces a proficiency-first framework that ensures organizations extract real value from their AI investments, going beyond surface-level engagement metrics.",
    },
    {
      title:
        "Beyond Chatbots: Create Autonomous AI Agents Using Microsoft Copilot Studio",
      speaker: "Himanshu Goil",
      category: "Microsoft Copilot",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "Learn how to design Autonomous AI Agents using Microsoft Copilot Studio that not only respond to user queries, but also proactively complete tasks, orchestrate workflows, and act with context and purpose. Covers multi-step reasoning, adaptive planning, and integrations across Microsoft 365.",
    },
    {
      title: "Fundamentals of Deep Learning – NVIDIA DLI Certified",
      speaker: "Amal Jlassi",
      category: "NVIDIA AI",
      type: "Full Day Workshop",
      duration: "Full Day",
      language: "French",
      description:
        "Official NVIDIA DLI hands-on training program providing practical experience in building, training, and deploying deep neural networks using TensorFlow and PyTorch. Taught by an NVIDIA DLI Certified Instructor.",
    },
    {
      title: "How AI is Empowering the Next Generation of Entrepreneurs",
      speaker: "Mohamed Aziz Bel Abed",
      category: "AI Startups",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "Personal journey building StarterPilot, an AI-powered platform designed to help anyone turn their startup idea into a real project. Live demo showing how AI is changing the game for entrepreneurs. Special bonus: Free access to StarterPilot for all attendees.",
    },
    {
      title: "The MCP Blueprint: Architecting Agentic AI",
      speaker: "Kasam Shaikh",
      category: "AI",
      type: "Session",
      duration: "45 mins",
      language: "English",
      description:
        "As the industry shifts to agentic AI systems, the Model Context Protocol (MCP) emerges as a game-changer. This session covers MCP architecture, AI agent development, integration with Microsoft's AI Stack, and live demo building a secure AI Assistant using Semantic Kernel and MCP.",
    },
    {
      title: "Unlocking Insights: The Power of NLP and OCR in Healthcare",
      speaker: "Dr. Mohamed Touati",
      category: "AI & Healthcare",
      type: "Keynote",
      duration: "45 mins",
      language: "English",
      description:
        "Explore how Natural Language Processing (NLP) and Optical Character Recognition (OCR) are revolutionizing healthcare. From automating clinical documentation to extracting insights from medical records, discover how AI can streamline workflows, reduce errors, and unlock healthcare data potential.",
    },
  ];

  // Populate sessions
  function populateSessions(sessions = sessionsData) {
    const sessionsGrid = document.getElementById("sessionsGrid");
    if (!sessionsGrid) return;

    sessionsGrid.innerHTML = sessions
      .map(
        (session) => `
            <div class="session-card" data-searchable="${session.title} ${session.speaker} ${session.category} ${session.description}">
                <div class="session-header">
                    <div>
                        <h3 class="session-title">${session.title}</h3>
                        <div class="session-speaker">${session.speaker}</div>
                    </div>
                </div>
                <div class="session-description">${session.description}</div>
                <div class="session-meta">
                    <span class="session-tag tag-category">${session.category}</span>
                    <span class="session-tag tag-type">${session.type}</span>
                    <span class="session-tag tag-duration">${session.duration}</span>
                    <span class="session-tag tag-language">${session.language}</span>
                </div>
            </div>
        `
      )
      .join("");
  }

  // Search and filter functionality
  function initializeSessionFilters() {
    const searchInput = document.getElementById("sessionSearch");
    const categoryFilter = document.getElementById("categoryFilter");
    const typeFilter = document.getElementById("typeFilter");
    const languageFilter = document.getElementById("languageFilter");

    function filterSessions() {
      const searchTerm = searchInput?.value.toLowerCase() || "";
      const categoryValue = categoryFilter?.value || "";
      const typeValue = typeFilter?.value || "";
      const languageValue = languageFilter?.value || "";

      const filteredSessions = sessionsData.filter((session) => {
        const matchesSearch =
          !searchTerm ||
          session.title.toLowerCase().includes(searchTerm) ||
          session.speaker.toLowerCase().includes(searchTerm) ||
          session.description.toLowerCase().includes(searchTerm) ||
          session.category.toLowerCase().includes(searchTerm);

        const matchesCategory =
          !categoryValue || session.category === categoryValue;
        const matchesType = !typeValue || session.type === typeValue;
        const matchesLanguage =
          !languageValue || session.language === languageValue;

        return (
          matchesSearch && matchesCategory && matchesType && matchesLanguage
        );
      });

      populateSessions(filteredSessions);
    }

    searchInput?.addEventListener("input", filterSessions);
    categoryFilter?.addEventListener("change", filterSessions);
    typeFilter?.addEventListener("change", filterSessions);
    languageFilter?.addEventListener("change", filterSessions);
  }

  // Initialize sessions
  populateSessions();
  initializeSessionFilters();

  // Startup form character counter
  const descriptionTextarea = document.getElementById("description");
  const charCount = document.querySelector(".char-count");

  if (descriptionTextarea && charCount) {
    descriptionTextarea.addEventListener("input", function () {
      const count = this.value.length;
      charCount.textContent = `${count}/2500 characters`;

      if (count > 2500) {
        charCount.style.color = "#EF4444";
      } else if (count > 2000) {
        charCount.style.color = "#F59E0B";
      } else {
        charCount.style.color = "rgba(255, 255, 255, 0.7)";
      }
    });
  }

  // Helper function to convert file to base64
  function fileToBase64(file) {
    return new Promise((resolve, reject) => {
      const reader = new FileReader();
      reader.readAsDataURL(file);
      reader.onload = () => {
        // Remove the data URL prefix (e.g., "data:application/pdf;base64,")
        const base64 = reader.result.split(",")[1];
        resolve(base64);
      };
      reader.onerror = (error) => reject(error);
    });
  }

  // Startup form submission
  const startupForm = document.getElementById("startupForm");
  if (startupForm) {
    startupForm.addEventListener("submit", async function (e) {
      e.preventDefault();

      // Validate required fields
      const requiredFields = this.querySelectorAll("[required]");
      let isValid = true;

      requiredFields.forEach((field) => {
        if (!field.value.trim()) {
          field.style.borderColor = "#EF4444";
          isValid = false;
        } else {
          field.style.borderColor = "rgba(255, 255, 255, 0.3)";
        }
      });

      if (!isValid) {
        showNotification("Please fill in all required fields.", "error");
        return;
      }

      // Show loading state
      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Submitting...";
      submitBtn.disabled = true;

      try {
        // Collect form data
        const formData = {
          startupName: this.startupName.value,
          founderName: this.founderName.value,
          email: this.email.value,
          phone: this.phone.value,
          website: this.website.value,
          stage: this.stage.value,
          aiCategory: this.aiCategory.value,
          description: this.description.value,
          traction: this.traction.value,
          funding: this.funding.value,
          teamSize: this.teamSize.value,
        };

        // Handle file upload if present
        const pitchDeckFile = this.pitchDeck.files[0];
        if (pitchDeckFile) {
          // Validate file size (10MB max)
          const maxSizeInBytes = 10 * 1024 * 1024; // 10MB
          if (pitchDeckFile.size > maxSizeInBytes) {
            throw new Error("Pitch deck file must be smaller than 10MB");
          }

          // Validate file type
          if (pitchDeckFile.type !== "application/pdf") {
            throw new Error("Pitch deck must be a PDF file");
          }

          const base64Data = await fileToBase64(pitchDeckFile);
          formData.pitchDeck = {
            name: pitchDeckFile.name,
            data: base64Data,
          };
        }

        // Submit to Google Apps Script using no-cors mode (standard for Apps Script)
        const startupUrl = FORM_URLS.startup;
        const response = await fetch(startupUrl, {
          method: "POST",
          mode: "no-cors", // This is required for Google Apps Script
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          "Your startup application has been submitted successfully! Our team will review your application and get back to you within 5 business days.",
          "success"
        );
        this.reset();

        // Reset character counter
        if (charCount) {
          charCount.textContent = "0/2500 characters";
          charCount.style.color = "rgba(255, 255, 255, 0.7)";
        }
      } catch (error) {
        showNotification(
          "There was an error submitting your application. Please try again later.",
          "error"
        );
      } finally {
        // Reset button state
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  }
  // B2B Form submission
  const b2bForm = document.getElementById("b2bForm");
  if (b2bForm) {
    b2bForm.addEventListener("submit", async function (e) {
      e.preventDefault();

      // Validate required fields
      const requiredFields = this.querySelectorAll("[required]");
      let isValid = true;

      requiredFields.forEach((field) => {
        if (!field.value.trim()) {
          field.style.borderColor = "#EF4444";
          isValid = false;
        } else {
          field.style.borderColor = "#E5E7EB";
        }
      });

      if (!isValid) {
        showNotification("Please fill in all required fields.", "error");
        return;
      }

      // Show loading state
      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Submitting...";
      submitBtn.disabled = true;

      try {
        // Collect form data
        const formInputs = this.querySelectorAll("input, select, textarea");
        const formData = {};

        formInputs.forEach((input) => {
          if (input.type === "checkbox") {
            if (!formData.companyTypes) formData.companyTypes = [];
            if (input.checked) formData.companyTypes.push(input.value);
          } else if (input.name || input.id) {
            const key = input.name || input.id;
            formData[key] = input.value;
          }
        });

        // Submit to Google Apps Script
        const response = await fetch(FORM_URLS.b2b, {
          method: "POST",
          mode: "no-cors",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          "Your B2B networking registration has been submitted successfully! Our team will contact you within 2 business days to schedule your meetings.",
          "success"
        );

        // Close modal and reset form
        const modal = this.closest(".modal");
        if (modal) closeModal(modal);
        this.reset();
      } catch (error) {
        showNotification(
          "There was an error submitting your registration. Please try again later.",
          "error"
        );
      } finally {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  }

  // Certification form submission
  const certificationForm = document.getElementById("certificationForm");
  if (certificationForm) {
    certificationForm.addEventListener("submit", async function (e) {
      e.preventDefault();

      // Validate required fields
      const requiredFields = this.querySelectorAll("[required]");
      let isValid = true;

      requiredFields.forEach((field) => {
        if (!field.value.trim()) {
          field.style.borderColor = "#EF4444";
          isValid = false;
        } else {
          field.style.borderColor = "#E5E7EB";
        }
      });

      if (!isValid) {
        showNotification("Please fill in all required fields.", "error");
        return;
      }

      // Show loading state
      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Submitting...";
      submitBtn.disabled = true;

      try {
        // Collect form data
        const formInputs = this.querySelectorAll("input, select, textarea");
        const formData = {};

        formInputs.forEach((input) => {
          if (input.name || input.id) {
            const key = input.name || input.id;
            formData[key] = input.value;
          }
        });

        // Submit to Google Apps Script
        const response = await fetch(FORM_URLS.certification, {
          method: "POST",
          mode: "no-cors",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          "Your AI certification enrollment has been submitted successfully! You will receive a confirmation email with payment instructions and course details within 24 hours.",
          "success"
        );

        // Close modal and reset form
        const modal = this.closest(".modal");
        if (modal) closeModal(modal);
        this.reset();
      } catch (error) {
        showNotification(
          "There was an error submitting your enrollment. Please try again later.",
          "error"
        );
      } finally {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  }

  // Newsletter form
  const newsletterForm = document.getElementById("newsletterForm");
  if (newsletterForm) {
    newsletterForm.addEventListener("submit", async function (e) {
      e.preventDefault();

      const email = this.querySelector('input[type="email"]').value;

      // Validate email
      if (!validateEmail(email)) {
        showNotification("Please enter a valid email address.", "error");
        return;
      }

      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Subscribing...";
      submitBtn.disabled = true;

      try {
        const formData = { email: email };

        await fetch(FORM_URLS.newsletter, {
          method: "POST",
          mode: "no-cors",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          "Thank you for subscribing! You will receive updates about AI Days Tunisia 2025.",
          "success"
        );
        this.reset();
      } catch (error) {
        showNotification(
          "There was an error subscribing. Please try again later.",
          "error"
        );
      } finally {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  }

  // Contact form
  const contactForm = document.getElementById("contactForm");
  if (contactForm) {
    contactForm.addEventListener("submit", async function (e) {
      e.preventDefault();

      // Validate required fields
      const requiredFields = this.querySelectorAll("[required]");
      let isValid = true;

      requiredFields.forEach((field) => {
        if (!field.value.trim()) {
          field.style.borderColor = "#EF4444";
          isValid = false;
        } else {
          field.style.borderColor = "#E5E7EB";
        }
      });

      if (!isValid) {
        showNotification("Please fill in all required fields.", "error");
        return;
      }

      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Sending...";
      submitBtn.disabled = true;

      try {
        // Collect form data
        const formInputs = this.querySelectorAll("input, select, textarea");
        const formData = {};

        formInputs.forEach((input) => {
          if (input.name || input.id) {
            const key = input.name || input.id;
            formData[key] = input.value;
          }
        });

        await fetch(FORM_URLS.contact, {
          method: "POST",
          mode: "no-cors",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          "Your message has been sent successfully! We will get back to you soon.",
          "success"
        );
        this.reset();
      } catch (error) {
        showNotification(
          "There was an error sending your message. Please try again later.",
          "error"
        );
      } finally {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  }

  // Paper submission form
  const paperForm = document.getElementById("paperForm");
  if (paperForm) {
    paperForm.addEventListener("submit", async function (e) {
      e.preventDefault();

      // Validate required fields
      const requiredFields = this.querySelectorAll("[required]");
      let isValid = true;

      requiredFields.forEach((field) => {
        if (!field.value.trim()) {
          field.style.borderColor = "#EF4444";
          isValid = false;
        } else {
          field.style.borderColor = "#E5E7EB";
        }
      });

      if (!isValid) {
        showNotification("Please fill in all required fields.", "error");
        return;
      }

      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Submitting...";
      submitBtn.disabled = true;

      try {
        // Collect form data
        const formInputs = this.querySelectorAll("input, select, textarea");
        const formData = {};

        // First collect non-file inputs
        formInputs.forEach((input) => {
          if (input.type !== "file" && (input.name || input.id)) {
            const key = input.name || input.id;
            formData[key] = input.value;
          }
        });

        // Handle file upload
        const fileInputs = this.querySelectorAll('input[type="file"]');
        for (const fileInput of fileInputs) {
          const file = fileInput.files[0];
          if (file) {
            // Validate file size (10MB max)
            const maxSizeInBytes = 10 * 1024 * 1024; // 10MB
            if (file.size > maxSizeInBytes) {
              throw new Error("File must be smaller than 10MB");
            }

            // Validate file type (PDF only for papers)
            if (file.type !== "application/pdf") {
              throw new Error("Paper must be a PDF file");
            }

            const base64Data = await fileToBase64(file);
            const fieldName = fileInput.name || fileInput.id || "paperFile";
            formData[fieldName] = {
              name: file.name,
              data: base64Data,
              type: file.type,
              size: file.size,
            };
          }
        }

        await fetch(FORM_URLS.paper, {
          method: "POST",
          mode: "no-cors",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          "Your paper has been submitted successfully! You will receive a confirmation email shortly.",
          "success"
        );
        this.reset();
      } catch (error) {
        showNotification(
          "There was an error submitting your paper. Please try again later.",
          "error"
        );
      } finally {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  }

  // Registration forms in modals
  const registrationForms = document.querySelectorAll(".registration-form");
  registrationForms.forEach((form) => {
    form.addEventListener("submit", async function (e) {
      e.preventDefault();

      // Validate required fields
      const requiredFields = this.querySelectorAll("[required]");
      let isValid = true;

      requiredFields.forEach((field) => {
        if (!field.value.trim()) {
          field.style.borderColor = "#EF4444";
          isValid = false;
        } else {
          field.style.borderColor = "#E5E7EB";
        }
      });

      if (!isValid) {
        showNotification("Please fill in all required fields.", "error");
        return;
      }

      const modal = this.closest(".modal");
      const modalTitle = modal.querySelector("h2").textContent;
      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.textContent = "Submitting...";
      submitBtn.disabled = true;

      try {
        // Collect form data
        const formInputs = this.querySelectorAll("input, select, textarea");
        const formData = {};

        formInputs.forEach((input) => {
          if (input.name || input.id) {
            const key = input.name || input.id;
            formData[key] = input.value;
          }
        });

        // Use registration URL from config
        await fetch(FORM_URLS.registration, {
          method: "POST",
          mode: "no-cors",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(formData),
        });

        showNotification(
          `Your ${modalTitle.toLowerCase()} has been submitted successfully! You will receive a confirmation email.`,
          "success"
        );

        // Close modal and reset form
        closeModal(modal);
        this.reset();
      } catch (error) {
        showNotification(
          "There was an error submitting your registration. Please try again later.",
          "error"
        );
      } finally {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });
  });
});

// Notification system
function showNotification(message, type = "success") {
  // Remove existing notifications
  const existingNotifications = document.querySelectorAll(".notification");
  existingNotifications.forEach((notification) => notification.remove());

  // Create notification element
  const notification = document.createElement("div");
  notification.classList.add("notification", `notification-${type}`);
  notification.innerHTML = `
        <div class="notification-content">
            <span class="notification-icon">${
              type === "success" ? "✓" : "⚠"
            }</span>
            <span class="notification-message">${message}</span>
            <button class="notification-close">&times;</button>
        </div>
    `;

  // Add notification styles
  const style = document.createElement("style");
  style.textContent = `
        .notification {
            position: fixed;
            top: 100px;
            right: 20px;
            z-index: 3000;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            animation: slideIn 0.3s ease;
            max-width: 400px;
        }
        
        .notification-success {
            border-left: 4px solid #10B981;
        }
        
        .notification-error {
            border-left: 4px solid #EF4444;
        }
        
        .notification-content {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px 20px;
        }
        
        .notification-icon {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 12px;
            color: white;
        }
        
        .notification-success .notification-icon {
            background: #10B981;
        }
        
        .notification-error .notification-icon {
            background: #EF4444;
        }
        
        .notification-message {
            flex: 1;
            color: #374151;
            font-size: 14px;
            line-height: 1.4;
        }
        
        .notification-close {
            background: none;
            border: none;
            font-size: 18px;
            color: #9CA3AF;
            cursor: pointer;
            padding: 0;
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .notification-close:hover {
            color: #374151;
        }
        
        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        @keyframes slideOut {
            from {
                transform: translateX(0);
                opacity: 1;
            }
            to {
                transform: translateX(100%);
                opacity: 0;
            }
        }
        
        @media (max-width: 768px) {
            .notification {
                right: 10px;
                left: 10px;
                max-width: none;
            }
        }
    `;

  if (!document.querySelector("style[data-notification-styles]")) {
    style.setAttribute("data-notification-styles", "true");
    document.head.appendChild(style);
  }

  // Add to document
  document.body.appendChild(notification);

  // Close notification functionality
  const closeBtn = notification.querySelector(".notification-close");
  closeBtn.addEventListener("click", () => {
    notification.style.animation = "slideOut 0.3s ease";
    setTimeout(() => notification.remove(), 300);
  });

  // Auto remove after 5 seconds
  setTimeout(() => {
    if (notification.parentNode) {
      notification.style.animation = "slideOut 0.3s ease";
      setTimeout(() => notification.remove(), 300);
    }
  }, 5000);
}

// Intersection Observer for animations
const observerOptions = {
  threshold: 0.1,
  rootMargin: "0px 0px -50px 0px",
};

const observer = new IntersectionObserver((entries) => {
  entries.forEach((entry) => {
    if (entry.isIntersecting) {
      entry.target.style.opacity = "1";
      entry.target.style.transform = "translateY(0)";
    }
  });
}, observerOptions);

// Add animation classes to elements
document.addEventListener("DOMContentLoaded", function () {
  const animateElements = document.querySelectorAll(
    ".goal-card, .speaker-card, .registration-card, .partnership-category"
  );

  animateElements.forEach((el) => {
    el.style.opacity = "0";
    el.style.transform = "translateY(30px)";
    el.style.transition = "all 0.6s ease";
    observer.observe(el);
  });
});

// Form validation
function validateEmail(email) {
  const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  return re.test(email);
}

function validateForm(form) {
  let isValid = true;
  const requiredFields = form.querySelectorAll("[required]");

  requiredFields.forEach((field) => {
    if (!field.value.trim()) {
      field.style.borderColor = "#EF4444";
      isValid = false;
    } else {
      field.style.borderColor = "#E5E7EB";
    }

    if (field.type === "email" && field.value && !validateEmail(field.value)) {
      field.style.borderColor = "#EF4444";
      isValid = false;
    }
  });

  return isValid;
}

// Add form validation to all forms (excluding forms with specific handlers)
document.addEventListener("DOMContentLoaded", function () {
  const forms = document.querySelectorAll("form");

  // Forms that have their own specific handlers - exclude from global validation
  const formsWithSpecificHandlers = [
    "startupForm",
    "b2bForm",
    "certificationForm",
    "newsletterForm",
    "contactForm",
    "paperForm",
  ];

  forms.forEach((form) => {
    const submitBtn = form.querySelector('button[type="submit"]');

    // Skip forms that have their own specific handlers
    if (submitBtn && !formsWithSpecificHandlers.includes(form.id)) {
      form.addEventListener("submit", function (e) {
        if (!validateForm(this)) {
          e.preventDefault();
          showNotification(
            "Please fill in all required fields correctly.",
            "error"
          );
          return false;
        }
      });
    }
  });
});

// Count up animation for stats
function countUp(element, target, duration = 2000) {
  let start = 0;
  const increment = target / (duration / 16);
  const timer = setInterval(() => {
    start += increment;
    element.textContent = Math.floor(start);
    if (start >= target) {
      element.textContent = target;
      clearInterval(timer);
    }
  }, 16);
}

// Trigger count up animation when stats come into view
document.addEventListener("DOMContentLoaded", function () {
  const stats = document.querySelectorAll(".stat-number");
  const statsObserver = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting && !entry.target.dataset.counted) {
          const target = parseInt(entry.target.textContent.replace("+", ""));
          countUp(entry.target, target);
          entry.target.dataset.counted = "true";
        }
      });
    },
    { threshold: 0.5 }
  );

  stats.forEach((stat) => statsObserver.observe(stat));
});

// Lazy loading for better performance
document.addEventListener("DOMContentLoaded", function () {
  const lazyElements = document.querySelectorAll("[data-lazy]");

  if ("IntersectionObserver" in window) {
    const lazyObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          const element = entry.target;
          element.src = element.dataset.lazy;
          element.classList.remove("lazy");
          lazyObserver.unobserve(element);
        }
      });
    });

    lazyElements.forEach((element) => lazyObserver.observe(element));
  }
});

// Search functionality for sessions/speakers (if needed later)
function initializeSearch() {
  const searchInput = document.querySelector(".search-input");
  if (searchInput) {
    searchInput.addEventListener("input", function (e) {
      const searchTerm = e.target.value.toLowerCase();
      const searchableItems = document.querySelectorAll("[data-searchable]");

      searchableItems.forEach((item) => {
        const text = item.textContent.toLowerCase();
        const isVisible = text.includes(searchTerm);
        item.style.display = isVisible ? "block" : "none";
      });
    });
  }
}
const cards = document.querySelectorAll(".goal-card");
const itemCount = cards.length;
let angle = 360 / itemCount;
let currAngle = 0;

function rotateCarousel() {
  cards.forEach((card, i) => {
    let theta = (i * angle + currAngle) * (Math.PI / 180);
    let x = 300 * Math.cos(theta);
    let z = 300 * Math.sin(theta);

    card.style.transform = `translateX(${x}px) translateZ(${z}px)`;
  });

  currAngle -= angle; // move to next
}

setInterval(rotateCarousel, 3000);
rotateCarousel();

// Enhanced Carousel UX functionality
function initializeCarouselUX() {
  const carousel = document.querySelector(".carousel");
  const carouselTrack = document.querySelector(".carousel-track");
  const pauseIndicator = document.querySelector(".carousel-pause-indicator");

  if (!carousel || !carouselTrack) return;

  let isHovered = false;
  let currentCard = 1;
  const totalCards = 5;

  // Show/hide pause indicator on hover
  carousel.addEventListener("mouseenter", () => {
    isHovered = true;
    if (pauseIndicator) {
      pauseIndicator.classList.add("show");
    }
  });

  carousel.addEventListener("mouseleave", () => {
    isHovered = false;
    if (pauseIndicator) {
      pauseIndicator.classList.remove("show");
    }
  });

  // Enhanced card interactions with 3D tilt and magnetic effects
  const goalCards = document.querySelectorAll(".goal-card");
  goalCards.forEach((card, index) => {
    // 3D Tilt Effect
    card.addEventListener("mousemove", (e) => {
      const rect = card.getBoundingClientRect();
      const centerX = rect.left + rect.width / 2;
      const centerY = rect.top + rect.height / 2;
      const mouseX = e.clientX - centerX;
      const mouseY = e.clientY - centerY;

      const rotateXUntilt = mouseY / (rect.height / 2);
      const rotateYUntilt = (-1 * mouseX) / (rect.width / 2);

      const rotateX = rotateXUntilt * 10;
      const rotateY = rotateYUntilt * 10;

      card.style.transform = `
        translateY(-20px) 
        scale(1.05) 
        rotateX(${rotateX}deg) 
        rotateY(${rotateY}deg)
        perspective(1000px)
      `;

      // Add subtle shadow movement
      const shadowX = mouseX / 10;
      const shadowY = mouseY / 10;
      card.style.boxShadow = `
        ${shadowX}px ${shadowY + 30}px 60px rgba(26, 109, 255, 0.25),
        ${shadowX / 2}px ${shadowY + 20}px 40px rgba(0, 0, 0, 0.15),
        0 0 0 1px rgba(26, 109, 255, 0.2),
        inset 0 1px 0 rgba(255, 255, 255, 0.8)
      `;
    });

    // Reset on mouse leave
    card.addEventListener("mouseleave", () => {
      card.style.transform = "";
      card.style.boxShadow = "";
    });

    // Enhanced click with ripple effect
    card.addEventListener("click", (e) => {
      // Add ripple effect
      const ripple = document.createElement("span");
      ripple.className = "card-ripple";
      ripple.style.cssText = `
        position: absolute;
        border-radius: 50%;
        background: radial-gradient(circle, rgba(26, 109, 255, 0.4) 0%, rgba(26, 109, 255, 0.1) 50%, transparent 100%);
        width: 100px;
        height: 100px;
        margin-left: -50px;
        margin-top: -50px;
        animation: ripple 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        pointer-events: none;
        z-index: 10;
      `;

      const rect = card.getBoundingClientRect();
      const left = e.clientX - rect.left;
      const top = e.clientY - rect.top;

      ripple.style.left = left + "px";
      ripple.style.top = top + "px";

      card.appendChild(ripple);

      // Add card pulse effect
      card.style.animation = "cardPulse 0.3s ease-out";

      setTimeout(() => {
        if (ripple.parentNode) {
          ripple.parentNode.removeChild(ripple);
        }
        card.style.animation = "";
      }, 800);
    });

    // Add focus support for accessibility
    card.setAttribute("tabindex", "0");
    card.addEventListener("keydown", (e) => {
      if (e.key === "Enter" || e.key === " ") {
        e.preventDefault();
        card.click();
      }
    });

    // Add magnetic attraction effect
    card.addEventListener("mouseenter", () => {
      card.style.zIndex = "10";
      // Slightly attract nearby cards
      const allCards = document.querySelectorAll(".goal-card");
      allCards.forEach((otherCard, otherIndex) => {
        if (otherCard !== card && Math.abs(otherIndex - index) <= 1) {
          otherCard.style.transform = "scale(0.98) translateY(-2px)";
          otherCard.style.transition = "transform 0.3s ease";
        }
      });
    });

    card.addEventListener("mouseleave", () => {
      card.style.zIndex = "";
      // Reset nearby cards
      const allCards = document.querySelectorAll(".goal-card");
      allCards.forEach((otherCard) => {
        if (otherCard !== card) {
          otherCard.style.transform = "";
        }
      });
    });
  });

  // Dynamic speed control based on user engagement
  let baseSpeed = 20; // seconds
  let currentSpeed = baseSpeed;
  let speedAdjustmentFactor = 1;

  const adjustCarouselSpeed = (factor) => {
    speedAdjustmentFactor = factor;
    const newDuration = baseSpeed * factor;
    carouselTrack.style.animationDuration = `${newDuration}s`;
  };

  // Slow down when user is actively engaging
  carousel.addEventListener("mouseenter", () => {
    adjustCarouselSpeed(2); // Slower when hovering
  });

  carousel.addEventListener("mouseleave", () => {
    adjustCarouselSpeed(1); // Normal speed
  });

  // Further slow down when user clicks on cards (showing high engagement)
  carousel.addEventListener("click", () => {
    adjustCarouselSpeed(3); // Much slower after click
    setTimeout(() => {
      if (!isHovered) {
        adjustCarouselSpeed(1); // Return to normal after 5 seconds
      }
    }, 5000);
  });

  // Performance optimization: pause animation when tab is not visible
  document.addEventListener("visibilitychange", () => {
    if (document.hidden) {
      carouselTrack.style.animationPlayState = "paused";
    } else if (!isHovered) {
      carouselTrack.style.animationPlayState = "running";
    }
  });

  // Enhanced Intersection Observer with fade effects
  const observer = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          carouselTrack.style.animationPlayState = "running";
          carousel.style.opacity = "1";
          carousel.style.transform = "translateY(0)";
        } else {
          carouselTrack.style.animationPlayState = "paused";
          carousel.style.opacity = "0.7";
          carousel.style.transform = "translateY(20px)";
        }
      });
    },
    {
      threshold: 0.2,
      rootMargin: "50px",
    }
  );

  observer.observe(carousel);

  // Add smooth scroll behavior for carousel indicators
  const indicators = document.querySelectorAll(".carousel-indicator");
  indicators.forEach((indicator, index) => {
    indicator.addEventListener("click", () => {
      // Calculate card position and smoothly adjust animation
      const cardWidth = 320 + 32; // card width + gap
      const targetOffset = -(cardWidth * index);

      // Temporarily pause animation
      carouselTrack.style.animationPlayState = "paused";

      // Smooth transition to target position
      carouselTrack.style.transition =
        "transform 0.8s cubic-bezier(0.4, 0, 0.2, 1)";
      carouselTrack.style.transform = `translateX(${targetOffset}px)`;

      // Resume animation after transition
      setTimeout(() => {
        carouselTrack.style.transition = "";
        carouselTrack.style.transform = "";
        carouselTrack.style.animationPlayState = "running";
      }, 800);
    });
  });
}

// Countdown Timer
function initializeCountdown() {
  const countdownElement = document.getElementById("countdown");
  if (!countdownElement) {
    return;
  }

  const daysEl = document.getElementById("days");
  const hoursEl = document.getElementById("hours");
  const minutesEl = document.getElementById("minutes");
  const secondsEl = document.getElementById("seconds");

  if (!daysEl || !hoursEl || !minutesEl || !secondsEl) {
    return;
  }

  const eventDate = new Date("2025-12-19T09:00:00").getTime();

  function updateCountdown() {
    const now = new Date().getTime();
    const distance = eventDate - now;

    if (distance < 0) {
      const eventLiveMessage =
        translations[currentLanguage]?.countdownEventLive || "Event is Live!";
      countdownElement.innerHTML = `<div class="event-live" data-translate="countdownEventLive">${eventLiveMessage}</div>`;
      clearInterval(countdownInterval);
      return;
    }

    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
    const hours = Math.floor(
      (distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)
    );
    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

    daysEl.textContent = String(days).padStart(2, "0");
    hoursEl.textContent = String(hours).padStart(2, "0");
    minutesEl.textContent = String(minutes).padStart(2, "0");
    secondsEl.textContent = String(seconds).padStart(2, "0");
  }

  const countdownInterval = setInterval(updateCountdown, 1000);
  updateCountdown(); // Initial call
}

// Add ripple animation CSS
const rippleCSS = `
@keyframes ripple {
  0% {
    transform: scale(0);
    opacity: 1;
  }
  50% {
    transform: scale(2);
    opacity: 0.7;
  }
  100% {
    transform: scale(4);
    opacity: 0;
  }
}
`;

// Inject ripple CSS
const style = document.createElement("style");
style.textContent = rippleCSS;
document.head.appendChild(style);

// ===== Enhanced Program Schedule Functionality =====

function initializeProgramInteractivity() {
  // Add day navigation
  createDayNavigation();

  // Add session type filtering
  createSessionTypeFilter();

  // Add expandable session details
  initializeExpandableDetails();

  // Add session search functionality
  initializeSessionSearch();

  // Add session bookmarking
  initializeSessionBookmarking();
}

function createDayNavigation() {
  const programSchedule = document.querySelector(".program-schedule");
  if (!programSchedule) return;

  // Create navigation tabs
  const dayNav = document.createElement("div");
  dayNav.className = "day-navigation";
  dayNav.innerHTML = `
    <div class="day-nav-container">
      <button class="day-nav-btn active" data-day="day1">

        <span class="day-title">Day 1</span>
        <span class="day-date">Dec 19</span>
        <span class="day-theme">Healthcare & Trust</span>
      </button>
      <button class="day-nav-btn" data-day="day2">

        <span class="day-title">Day 2</span>
        <span class="day-date">Dec 20</span>
        <span class="day-theme">Architecture & Apps</span>
      </button>
      <button class="day-nav-btn" data-day="day3">
        <span class="day-title">Day 3</span>
        <span class="day-date">Dec 21</span>
        <span class="day-theme">Biology & Future</span>
      </button>
    </div>
  `;

  programSchedule.parentNode.insertBefore(dayNav, programSchedule);

  // Add navigation functionality
  const navButtons = dayNav.querySelectorAll(".day-nav-btn");
  const scheduleDays = programSchedule.querySelectorAll(".schedule-day");

  // Initially hide all days except first
  scheduleDays.forEach((day, index) => {
    if (index !== 0) day.style.display = "none";
  });

  navButtons.forEach((btn, index) => {
    btn.addEventListener("click", () => {
      // Update active button
      navButtons.forEach((b) => b.classList.remove("active"));
      btn.classList.add("active");

      // Show corresponding day
      scheduleDays.forEach((day) => (day.style.display = "none"));
      if (scheduleDays[index]) {
        scheduleDays[index].style.display = "block";
        scheduleDays[index].style.animation = "fadeInUp 0.5s ease-out";
      }
    });
  });
}

function createSessionTypeFilter() {
  const programSection = document.querySelector("#program");
  if (!programSection) return;

  const filterContainer = document.createElement("div");
  filterContainer.className = "session-type-filter";
  filterContainer.innerHTML = `
    <div class="filter-header">
      <h4>Filter by Session Type:</h4>
    </div>
    <div class="filter-buttons">
      <button class="filter-btn active" data-type="all">All Sessions</button>
      <button class="filter-btn" data-type="keynote">🎤 Keynotes</button>
      <button class="filter-btn" data-type="panel">👥 Panels</button>
      <button class="filter-btn" data-type="parallel-block">🔧 Workshops</button>
      <button class="filter-btn" data-type="networking">🤝 Networking</button>
      <button class="filter-btn" data-type="startup">🚀 Startup Track</button>
      <button class="filter-btn" data-type="social">🎉 Social Events</button>
    </div>
  `;

  const programSchedule = document.querySelector(".program-schedule");
  programSchedule.parentNode.insertBefore(filterContainer, programSchedule);

  // Add filter functionality
  const filterButtons = filterContainer.querySelectorAll(".filter-btn");

  filterButtons.forEach((btn) => {
    btn.addEventListener("click", () => {
      // Update active button
      filterButtons.forEach((b) => b.classList.remove("active"));
      btn.classList.add("active");

      const filterType = btn.dataset.type;
      const scheduleItems = document.querySelectorAll(".schedule-item");

      scheduleItems.forEach((item) => {
        if (filterType === "all" || item.classList.contains(filterType)) {
          item.style.display = "flex";
          item.style.animation = "fadeIn 0.3s ease-in";
        } else {
          item.style.display = "none";
        }
      });
    });
  });
}

function initializeExpandableDetails() {
  const scheduleItems = document.querySelectorAll(".schedule-item");

  scheduleItems.forEach((item) => {
    // Add expand button for items with detailed content
    const hasDetails = item.querySelector(
      ".speakers, .description, .parallel-content"
    );
    if (!hasDetails) return;

    const expandBtn = document.createElement("button");
    expandBtn.className = "expand-btn";
    expandBtn.innerHTML =
      '<span>Details</span> <i class="fas fa-chevron-down"></i>';

    const session = item.querySelector(".session");
    session.appendChild(expandBtn);

    // Initially hide detailed content
    const detailElements = item.querySelectorAll(
      ".speakers, .description, .parallel-content, .moderator, .judges, .mentors, .prizes, .focus"
    );
    detailElements.forEach((el) => {
      el.style.display = "none";
      el.classList.add("expandable-content");
    });

    // Add expand/collapse functionality
    expandBtn.addEventListener("click", (e) => {
      e.stopPropagation();
      const isExpanded = item.classList.contains("expanded");

      if (isExpanded) {
        item.classList.remove("expanded");
        detailElements.forEach((el) => (el.style.display = "none"));
        expandBtn.innerHTML =
          '<span>Details</span> <i class="fas fa-chevron-down"></i>';
      } else {
        item.classList.add("expanded");
        detailElements.forEach((el) => (el.style.display = "block"));
        expandBtn.innerHTML =
          '<span>Less</span> <i class="fas fa-chevron-up"></i>';
      }
    });
  });
}

function initializeSessionSearch() {
  const programSection = document.querySelector("#program");
  if (!programSection) return;

  const searchContainer = document.createElement("div");
  searchContainer.className = "program-search";
  searchContainer.innerHTML = `
    <div class="search-input-container">
      <input type="text" id="programSearch" placeholder="Search sessions, speakers, or topics..." class="program-search-input">
      <i class="fas fa-search search-icon"></i>
      <button class="clear-search" style="display: none;"><i class="fas fa-times"></i></button>
    </div>
  `;

  const programContent = document.querySelector(".program-content");
  programContent.insertBefore(searchContainer, programContent.firstChild);

  const searchInput = searchContainer.querySelector("#programSearch");
  const clearBtn = searchContainer.querySelector(".clear-search");

  searchInput.addEventListener("input", (e) => {
    const searchTerm = e.target.value.toLowerCase();
    const scheduleItems = document.querySelectorAll(".schedule-item");

    if (searchTerm) {
      clearBtn.style.display = "block";
    } else {
      clearBtn.style.display = "none";
    }

    scheduleItems.forEach((item) => {
      const text = item.textContent.toLowerCase();
      if (text.includes(searchTerm)) {
        item.style.display = "flex";
        item.style.animation = "fadeIn 0.3s ease-in";
        // Highlight search term
        highlightSearchTerm(item, searchTerm);
      } else {
        item.style.display = "none";
      }
    });
  });

  clearBtn.addEventListener("click", () => {
    searchInput.value = "";
    clearBtn.style.display = "none";
    const scheduleItems = document.querySelectorAll(".schedule-item");
    scheduleItems.forEach((item) => {
      item.style.display = "flex";
      removeHighlights(item);
    });
  });
}

function highlightSearchTerm(element, term) {
  if (!term) return;

  const walker = document.createTreeWalker(
    element,
    NodeFilter.SHOW_TEXT,
    null,
    false
  );

  const textNodes = [];
  let node;

  while ((node = walker.nextNode())) {
    if (node.nodeValue.toLowerCase().includes(term)) {
      textNodes.push(node);
    }
  }

  textNodes.forEach((textNode) => {
    const parent = textNode.parentNode;
    const regex = new RegExp(`(${term})`, "gi");
    const highlightedText = textNode.nodeValue.replace(
      regex,
      "<mark>$1</mark>"
    );

    const wrapper = document.createElement("span");
    wrapper.innerHTML = highlightedText;
    parent.replaceChild(wrapper, textNode);
  });
}

function removeHighlights(element) {
  const highlights = element.querySelectorAll("mark");
  highlights.forEach((mark) => {
    mark.outerHTML = mark.innerHTML;
  });
}

function initializeSessionBookmarking() {
  const scheduleItems = document.querySelectorAll(".schedule-item");

  scheduleItems.forEach((item, index) => {
    const bookmarkBtn = document.createElement("button");
    bookmarkBtn.className = "bookmark-btn";
    bookmarkBtn.innerHTML = '<i class="far fa-bookmark"></i>';
    bookmarkBtn.title = "Bookmark this session";

    const session = item.querySelector(".session");
    session.style.position = "relative";
    session.appendChild(bookmarkBtn);

    // Check if session is already bookmarked
    const bookmarkedSessions = JSON.parse(
      localStorage.getItem("bookmarkedSessions") || "[]"
    );
    if (bookmarkedSessions.includes(index)) {
      bookmarkBtn.classList.add("bookmarked");
      bookmarkBtn.innerHTML = '<i class="fas fa-bookmark"></i>';
    }

    bookmarkBtn.addEventListener("click", (e) => {
      e.stopPropagation();

      let bookmarked = JSON.parse(
        localStorage.getItem("bookmarkedSessions") || "[]"
      );

      if (bookmarkBtn.classList.contains("bookmarked")) {
        bookmarkBtn.classList.remove("bookmarked");
        bookmarkBtn.innerHTML = '<i class="far fa-bookmark"></i>';
        bookmarked = bookmarked.filter((id) => id !== index);
      } else {
        bookmarkBtn.classList.add("bookmarked");
        bookmarkBtn.innerHTML = '<i class="fas fa-bookmark"></i>';
        bookmarked.push(index);
      }

      localStorage.setItem("bookmarkedSessions", JSON.stringify(bookmarked));
    });
  });
}

// Add CSS for the new interactive elements
const programInteractiveCSS = `
/* Day Navigation */
.day-navigation {
  margin-bottom: 3rem;
}

.day-nav-container {
  display: flex;
  gap: 1rem;
  justify-content: center;
  flex-wrap: wrap;
}

.day-nav-btn {
  background: var(--card-bg);
  border: 2px solid var(--card-border);
  border-radius: 15px;
  padding: 1.5rem;
  cursor: pointer;
  transition: all 0.3s ease;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 0.5rem;
  min-width: 150px;
  text-align: center;
}

.day-nav-btn:hover {
  border-color: var(--primary-color);
  transform: translateY(-2px);
  box-shadow: var(--card-shadow-hover);
}

.day-nav-btn.active {
  background: var(--primary-color);
  color: white;
  border-color: var(--primary-color);
}

.day-emoji {
  font-size: 2rem;
}

.day-title {
  font-weight: 600;
  font-size: 1.1rem;
}

.day-date {
  font-size: 0.9rem;
  opacity: 0.8;
}

.day-theme {
  font-size: 0.8rem;
  opacity: 0.7;
  font-style: italic;
}

/* Session Type Filter */
.session-type-filter {
  background: var(--card-bg);
  padding: 2rem;
  border-radius: 15px;
  margin-bottom: 3rem;
  border: 1px solid var(--card-border);
}

.filter-header h4 {
  margin-bottom: 1rem;
  color: var(--text-primary);
}

.filter-buttons {
  display: flex;
  gap: 0.5rem;
  flex-wrap: wrap;
}

.filter-btn {
  background: var(--background-secondary);
  border: 1px solid var(--card-border);
  padding: 0.5rem 1rem;
  border-radius: 25px;
  cursor: pointer;
  transition: all 0.3s ease;
  font-size: 0.9rem;
}

.filter-btn:hover {
  background: var(--card-bg-hover);
  border-color: var(--primary-color);
}

.filter-btn.active {
  background: var(--primary-color);
  color: white;
  border-color: var(--primary-color);
}

/* Program Search */
.program-search {
  margin-bottom: 2rem;
}

.search-input-container {
  position: relative;
  max-width: 500px;
  margin: 0 auto;
}

.program-search-input {
  width: 100%;
  padding: 1rem 3rem 1rem 1rem;
  border: 2px solid var(--card-border);
  border-radius: 25px;
  font-size: 1rem;
  background: var(--card-bg);
  color: var(--text-primary);
  transition: all 0.3s ease;
}

.program-search-input:focus {
  outline: none;
  border-color: var(--primary-color);
  box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
}

.search-icon {
  position: absolute;
  right: 1rem;
  top: 50%;
  transform: translateY(-50%);
  color: var(--text-tertiary);
}

.clear-search {
  position: absolute;
  right: 3rem;
  top: 50%;
  transform: translateY(-50%);
  background: none;
  border: none;
  cursor: pointer;
  color: var(--text-tertiary);
  padding: 0.2rem;
}

/* Expand Button */
.expand-btn {
  background: var(--primary-color);
  color: white;
  border: none;
  padding: 0.5rem 1rem;
  border-radius: 20px;
  cursor: pointer;
  font-size: 0.8rem;
  margin-top: 1rem;
  transition: all 0.3s ease;
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

.expand-btn:hover {
  background: var(--primary-hover);
  transform: translateY(-1px);
}

.expand-btn i {
  transition: transform 0.3s ease;
}

.expanded .expand-btn i {
  transform: rotate(180deg);
}

/* Bookmark Button */
.bookmark-btn {
  position: absolute;
  top: 0.5rem;
  right: 0.5rem;
  background: none;
  border: none;
  cursor: pointer;
  color: var(--text-tertiary);
  font-size: 1.2rem;
  transition: all 0.3s ease;
  padding: 0.5rem;
  border-radius: 50%;
}

.bookmark-btn:hover {
  background: var(--card-bg-hover);
  color: var(--accent-color);
}

.bookmark-btn.bookmarked {
  color: var(--accent-color);
}

/* Search Highlights */
mark {
  background: var(--accent-color);
  color: white;
  padding: 0.1rem 0.2rem;
  border-radius: 3px;
}

/* Animations */
@keyframes fadeIn {
  from { opacity: 0; }
  to { opacity: 1; }
}

@keyframes fadeInUp {
  from { 
    opacity: 0; 
    transform: translateY(20px);
  }
  to { 
    opacity: 1; 
    transform: translateY(0);
  }
}

/* Responsive Design */
@media (max-width: 768px) {
  .day-nav-container {
    flex-direction: column;
    align-items: center;
  }
  
  .day-nav-btn {
    min-width: 120px;
    padding: 1rem;
  }
  
  .filter-buttons {
    justify-content: center;
  }
  
  .filter-btn {
    font-size: 0.8rem;
    padding: 0.4rem 0.8rem;
  }
  
  .program-search-input {
    padding: 0.8rem 2.5rem 0.8rem 1rem;
    font-size: 0.9rem;
  }
}
`;

// Initialize all functionality
document.addEventListener("DOMContentLoaded", function () {
  initializeSearch();
  initializeCarouselUX();
  // initializeProgramInteractivity(); // DISABLED - Show all content by default

  // Inject program interactive CSS
  // const programStyle = document.createElement("style");
  // programStyle.textContent = programInteractiveCSS;
  // document.head.appendChild(programStyle);
});
